﻿CREATE OR REPLACE FUNCTION alterTable() 
RETURNS VOID AS 
$BODY$ 
DECLARE
	msgFinal text := 'FOI CRIADA';
BEGIN 
IF NOT EXISTS (SELECT 1 FROM information_schema.columns 
					WHERE table_name= 'pdv_cupom_nao_fiscal_est_rps_it') THEN 

	CREATE TABLE public.pdv_cupom_nao_fiscal_est_rps_it
	(
		cd_ctr numeric(6,0) NOT NULL DEFAULT 0,
		cd_emp numeric(6,0) NOT NULL DEFAULT 0,
		cd_filial numeric(6,0) NOT NULL DEFAULT 0,
		cd_cx numeric(6,0) NOT NULL DEFAULT 0,
		cd_ctr_it numeric(6,0) NOT NULL DEFAULT 0,
		cd_prod numeric(6,0) NOT NULL DEFAULT 0,
		qt_it numeric(6,2) NOT NULL DEFAULT 0,
		vlr_unitario numeric(6,2),
		vlr_desconto numeric(6,2),
		vlr_total numeric(6,2),
		CONSTRAINT pdv_cupom_nao_fiscal_est_rps_it_pkey PRIMARY KEY (cd_emp, cd_filial, cd_cx, cd_ctr, cd_ctr_it),
		CONSTRAINT pdv_cupom_nao_fiscal_est_rps_it_fkey FOREIGN KEY (cd_emp, cd_filial, cd_cx, cd_ctr)
		REFERENCES public.pdv_cupom_nao_fiscal_est_rps (cd_emp, cd_filial, cd_cx, cd_ctr) MATCH SIMPLE
		ON UPDATE CASCADE ON DELETE CASCADE
	)
	WITH (
	OIDS=FALSE
	);
	ALTER TABLE public.pdv_cupom_nao_fiscal_est_rps_it
	OWNER TO postgres;

ELSE    
	msgFinal := 'JÁ EXISTE';
END IF;

RAISE NOTICE 'TABELA pdv_cupom_nao_fiscal_est_rps_it %', msgFinal::varchar;

END; 
-- fim bloco principal 
$BODY$ 
LANGUAGE plpgsql VOLATILE 
  COST 100; 
ALTER FUNCTION alterTable() OWNER TO postgres; 
SELECT alterTable(); 
DROP FUNCTION alterTable();
